/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayUpdate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.MultiElementCounter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SingleUpdateNormalFormTransformer {
    static final String s_AuxArray = "auxArray";
    private final List<ArrayUpdate> mArrayUpdates;
    private List<Term> mRemainderTerms;
    private Map<Term, Term> mStore2TermVariable;
    private final Script mScript;
    private final FreshAuxVarGenerator mFreshAuxVarGenerator;

    public SingleUpdateNormalFormTransformer(Term term, Script script, FreshAuxVarGenerator freshAuxVarGenerator) {
        this.mScript = script;
        this.mFreshAuxVarGenerator = freshAuxVarGenerator;
        this.mArrayUpdates = new ArrayList<ArrayUpdate>();
        Term[] termArray = SmtUtils.getConjuncts((Term)term);
        ArrayUpdate.ArrayUpdateExtractor arrayUpdateExtractor = new ArrayUpdate.ArrayUpdateExtractor(false, true, termArray);
        this.mRemainderTerms = arrayUpdateExtractor.getRemainingTerms();
        this.mArrayUpdates.addAll(arrayUpdateExtractor.getArrayUpdates());
        this.mStore2TermVariable = arrayUpdateExtractor.getStore2TermVariable();
        while (true) {
            if (!this.mStore2TermVariable.isEmpty()) {
                this.processNewArrayUpdates();
                continue;
            }
            MultiDimensionalStore multiDimensionalStore = this.extractStore(this.mArrayUpdates, this.mRemainderTerms);
            if (multiDimensionalStore == null) break;
            this.processNewStore(multiDimensionalStore);
        }
        assert (this.mStore2TermVariable.isEmpty());
    }

    private void processNewStore(MultiDimensionalStore multiDimensionalStore) {
        Term term = multiDimensionalStore.getArray();
        TermVariable termVariable = this.mFreshAuxVarGenerator.constructFreshCopy(term);
        assert (this.mStore2TermVariable.isEmpty());
        this.mStore2TermVariable = Collections.singletonMap(multiDimensionalStore.toTerm(this.mScript), termVariable);
        Term term2 = this.mScript.term("=", new Term[]{termVariable, multiDimensionalStore.toTerm(this.mScript)});
        ArrayUpdate.ArrayUpdateExtractor arrayUpdateExtractor = new ArrayUpdate.ArrayUpdateExtractor(false, true, new Term[]{term2});
        assert (arrayUpdateExtractor.getArrayUpdates().size() == 1);
        this.mArrayUpdates.add((ArrayUpdate)arrayUpdateExtractor.getArrayUpdates().get(0));
    }

    private MultiDimensionalStore extractStore(List<ArrayUpdate> list, List<Term> list2) {
        List list32;
        for (ArrayUpdate arrayUpdate : list) {
            for (List list32 : arrayUpdate.getIndex()) {
                List list4 = MultiDimensionalStore.extractArrayStoresDeep((Term)list32);
                if (!list4.isEmpty()) {
                    throw new AssertionError((Object)"not yet implemented");
                }
            }
            list32 = MultiDimensionalStore.extractArrayStoresDeep((Term)arrayUpdate.getValue());
            if (!list32.isEmpty()) {
                throw new AssertionError((Object)"not yet implemented");
            }
        }
        for (Term term : list2) {
            list32 = MultiDimensionalStore.extractArrayStoresDeep((Term)term);
            if (list32.isEmpty()) continue;
            return (MultiDimensionalStore)list32.get(0);
        }
        return null;
    }

    private void processNewArrayUpdates() {
        Term term;
        ArrayUpdate arrayUpdate2;
        for (ArrayUpdate arrayUpdate2 : this.mArrayUpdates) {
            Term term22;
            for (Term term22 : arrayUpdate2.getIndex()) {
                term = PureSubstitution.apply((Script)this.mScript, this.mStore2TermVariable, (Term)term22);
                if (term != term22) {
                    throw new AssertionError((Object)"not yet implemented");
                }
            }
            term22 = PureSubstitution.apply((Script)this.mScript, this.mStore2TermVariable, (Term)arrayUpdate2.getValue());
            if (term22 != arrayUpdate2.getValue()) {
                throw new AssertionError((Object)"not yet implemented");
            }
        }
        arrayUpdate2 = new ArrayList();
        HashMap hashMap = new HashMap();
        for (Term term22 : this.mRemainderTerms) {
            term = PureSubstitution.apply((Script)this.mScript, this.mStore2TermVariable, (Term)term22);
            ArrayUpdate.ArrayUpdateExtractor arrayUpdateExtractor = new ArrayUpdate.ArrayUpdateExtractor(false, true, new Term[]{term});
            assert (arrayUpdateExtractor.getArrayUpdates().size() == 0 || arrayUpdateExtractor.getArrayUpdates().size() == 1);
            if (arrayUpdateExtractor.getArrayUpdates().isEmpty()) {
                arrayUpdate2.add(term);
                continue;
            }
            this.mArrayUpdates.addAll(arrayUpdateExtractor.getArrayUpdates());
            hashMap.putAll(arrayUpdateExtractor.getStore2TermVariable());
        }
        this.mRemainderTerms = arrayUpdate2;
        this.mStore2TermVariable = hashMap;
    }

    private MultiDimensionalStore getNonUpdateStore(Term term) {
        Term[] termArray = SmtUtils.getConjuncts((Term)term);
        ArrayUpdate.ArrayUpdateExtractor arrayUpdateExtractor = new ArrayUpdate.ArrayUpdateExtractor(false, true, termArray);
        Term term2 = SmtUtils.and((Script)this.mScript, (Term[])arrayUpdateExtractor.getRemainingTerms().toArray(new Term[0]));
        term2 = PureSubstitution.apply((Script)this.mScript, (Map)arrayUpdateExtractor.getStore2TermVariable(), (Term)term2);
        List list = MultiDimensionalStore.extractArrayStoresDeep((Term)term2);
        if (list.isEmpty()) {
            return null;
        }
        return (MultiDimensionalStore)list.get(0);
    }

    public List<ArrayUpdate> getArrayUpdates() {
        return Collections.unmodifiableList(this.mArrayUpdates);
    }

    public Term getRemainderTerm() {
        return SmtUtils.and((Script)this.mScript, (Term[])this.mRemainderTerms.toArray(new Term[this.mRemainderTerms.size()]));
    }

    public Set<TermVariable> getAuxVars() {
        return this.mFreshAuxVarGenerator.getAuxVars();
    }

    public static class FreshAuxVarGenerator {
        private final Map<TermVariable, Term> mFreshCopyToOriginal = new HashMap<TermVariable, Term>();
        private final MultiElementCounter<Term> mFreshCopyCounter = new MultiElementCounter();
        private final ReplacementVarFactory mReplacementVarFactory;

        public FreshAuxVarGenerator(ReplacementVarFactory replacementVarFactory) {
            this.mReplacementVarFactory = replacementVarFactory;
        }

        TermVariable constructFreshCopy(Term term) {
            Term term2 = this.mFreshCopyToOriginal.get(term);
            if (term2 == null) {
                term2 = term;
            }
            Integer n = this.mFreshCopyCounter.increment((Object)term2);
            String string = SmtUtils.removeSmtQuoteCharacters((String)term2.toString()) + SingleUpdateNormalFormTransformer.s_AuxArray + String.valueOf(n);
            TermVariable termVariable = this.mReplacementVarFactory.getOrConstructAuxVar(string, term.getSort());
            this.mFreshCopyToOriginal.put(termVariable, term2);
            return termVariable;
        }

        public Set<TermVariable> getAuxVars() {
            return this.mFreshCopyToOriginal.keySet();
        }
    }
}

