/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.AxiomsAdderIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeMemlocInitializingTransformula;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeStoreInfosAndArrayGroups;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.FindSelects;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapPartitionManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSepSettings;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSeparatorBenchmark;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.MemlocArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SelectInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.AddInitializingEdgesIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.MemlocArrayUpdaterTransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.PartitionProjectionTransitionTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.CongruenceClosureSmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.HeapSepProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IEqualityAnalysisResultProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IEqualityProvidingIntermediateState;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HeapSepIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private IIcfg<OUTLOC> mResultIcfg;
    private final List<IProgramVarOrConst> mHeapArrays;
    private final ILogger mLogger;
    private final HeapSeparatorBenchmark mStatistics;
    private final ManagedScript mMgdScript;
    private final HeapSepSettings mSettings;
    private final IUltimateServiceProvider mServices;
    public static final String MEMORY = "#memory";

    public HeapSepIcfgTransformer(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, ReplacementVarFactory replacementVarFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, Class<OUTLOC> clazz, String string, IEqualityAnalysisResultProvider<IcfgLocation, IIcfg<?>> iEqualityAnalysisResultProvider, IProgramNonOldVar iProgramNonOldVar2) {
        assert (iLogger != null);
        this.mStatistics = new HeapSeparatorBenchmark();
        this.mMgdScript = iIcfg.getCfgSmtToolkit().getManagedScript();
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mSettings = new HeapSepSettings();
        this.mHeapArrays = iIcfg.getCfgSmtToolkit().getSymbolTable().getGlobals().stream().filter(iProgramNonOldVar -> iProgramNonOldVar.getGloballyUniqueId().startsWith(MEMORY)).collect(Collectors.toList());
        this.mLogger.info((Object)"HeapSepIcfgTransformer: Starting heap partitioning");
        this.mLogger.info((Object)("To be partitioned heap arrays found " + String.valueOf(this.mHeapArrays)));
        this.computeResult(iIcfg, iLocationFactory, replacementVarFactory, icfgTransformationBacktranslator, clazz, string, iEqualityAnalysisResultProvider, iProgramNonOldVar2);
    }

    private void computeResult(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, ReplacementVarFactory replacementVarFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, Class<OUTLOC> clazz, String string, IEqualityAnalysisResultProvider<IcfgLocation, IIcfg<?>> iEqualityAnalysisResultProvider, IProgramNonOldVar iProgramNonOldVar) {
        Term term;
        this.mSettings.isDumpPrograms();
        ILocationFactory<BoogieIcfgLocation, BoogieIcfgLocation> iLocationFactory2 = HeapSepIcfgTransformer.createIcfgLocationToIcfgLocationFactory();
        ComputeStoreInfosAndArrayGroups<INLOC> computeStoreInfosAndArrayGroups = new ComputeStoreInfosAndArrayGroups<INLOC>(iIcfg, this.mHeapArrays, this.mMgdScript);
        MemlocArrayManager memlocArrayManager = computeStoreInfosAndArrayGroups.getLocArrayManager();
        this.mLogger.info((Object)"Heap separator: starting loc-array-style preprocessing");
        HashMap<IcfgEdge, IcfgEdge> hashMap = new HashMap<IcfgEdge, IcfgEdge>();
        MemlocArrayUpdaterTransformulaTransformer memlocArrayUpdaterTransformulaTransformer = new MemlocArrayUpdaterTransformulaTransformer(this.mServices, this.mLogger, iIcfg.getCfgSmtToolkit(), memlocArrayManager, this.mHeapArrays, computeStoreInfosAndArrayGroups.getEdgeToPositionToLocUpdateInfo());
        Object object = new IcfgTransformationBacktranslator(IcfgEdge.class, Term.class, this.mLogger);
        Object object2 = new IcfgTransformer<INLOC, OUTLOC>(this.mLogger, iIcfg, iLocationFactory, (IcfgTransformationBacktranslator)((Object)object), clazz, "icfg_with_locarrays", memlocArrayUpdaterTransformulaTransformer);
        IIcfg<OUTLOC> iIcfg2 = ((IcfgTransformer)object2).getResult();
        for (Map.Entry<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> partitionProjectionTransitionTransformer2 : ((IcfgTransformationBacktranslator)((Object)object)).getEdgeMapping().entrySet()) {
            hashMap.put((IcfgEdge)partitionProjectionTransitionTransformer2.getValue(), (IcfgEdge)partitionProjectionTransitionTransformer2.getKey());
        }
        memlocArrayManager.freeze();
        this.mLogger.info((Object)"finished MemlocArrayUpdater");
        object = new ComputeMemlocInitializingTransformula(memlocArrayManager, (IProgramVar)iProgramNonOldVar, this.mSettings, this.mMgdScript);
        object2 = new AddInitializingEdgesIcfgTransformer<BoogieIcfgLocation, BoogieIcfgLocation>(this.mLogger, iIcfg2.getCfgSmtToolkit(), iLocationFactory2, icfgTransformationBacktranslator, clazz, iIcfg2, ((ComputeMemlocInitializingTransformula)object).getResult(), "icfg_with_initialized_loc_arrays");
        memlocArrayUpdaterTransformulaTransformer = ((AddInitializingEdgesIcfgTransformer)object2).getResult();
        HashSet<HeapSepProgramConst> hashSet = new HashSet<HeapSepProgramConst>();
        hashSet.addAll(computeStoreInfosAndArrayGroups.getLocLiterals());
        hashSet.addAll(memlocArrayManager.getInitLocLits());
        iEqualityAnalysisResultProvider.announceAdditionalLiterals(hashSet);
        Object object3 = hashSet.stream().map(iProgramConst -> iProgramConst.getTerm()).collect(Collectors.toSet());
        assert (this.mSettings.isAssertFreezeVarLitDisequalitiesIntoScript() != this.mSettings.isAddLiteralDisequalitiesAsAxioms()) : "exactly one solution for literals in script should be enabled";
        if (this.mSettings.isAssertFreezeVarLitDisequalitiesIntoScript()) {
            this.assertLiteralDisequalitiesIntoScript((Set<Term>)object3);
        }
        if (this.mSettings.isAddLiteralDisequalitiesAsAxioms()) {
            term = SmtUtils.and((Script)this.mMgdScript.getScript(), (Collection)CongruenceClosureSmtUtils.createDisequalityTermsForNonTheoryLiterals((Script)this.mMgdScript.getScript(), (Set)object3));
            memlocArrayUpdaterTransformulaTransformer = new AxiomsAdderIcfgTransformer<BoogieIcfgLocation, BoogieIcfgLocation>(this.mLogger, "icfg_with_memloc_updates_and_literal_axioms", clazz, iIcfg2, iLocationFactory2, icfgTransformationBacktranslator, term).getResult();
        }
        MemlocArrayUpdaterTransformulaTransformer memlocArrayUpdaterTransformulaTransformer2 = memlocArrayUpdaterTransformulaTransformer;
        this.mLogger.info((Object)"finished preprocessing for the equality analysis");
        object = new ArrayList();
        object.add("#loc");
        object.add("valid");
        iEqualityAnalysisResultProvider.setTrackedArrays((List)object);
        iEqualityAnalysisResultProvider.preprocess(memlocArrayUpdaterTransformulaTransformer2);
        this.mLogger.info((Object)"finished equality analysis");
        object = new FindSelects(this.mLogger, this.mMgdScript, this.mHeapArrays, this.mStatistics, computeStoreInfosAndArrayGroups);
        new IcfgEdgeIterator(iIcfg).forEachRemaining(arg_0 -> HeapSepIcfgTransformer.lambda$2((FindSelects)object, arg_0));
        ((FindSelects)object).finish();
        this.mLogger.info((Object)"Finished detection of select terms (\"array reads\")");
        object2 = new HeapPartitionManager(this.mLogger, this.mMgdScript, this.mHeapArrays, this.mStatistics, memlocArrayManager, computeStoreInfosAndArrayGroups);
        for (SelectInfo selectInfo : ((FindSelects)object).getSelectInfos()) {
            term = (IcfgEdge)hashMap.get(selectInfo.getEdgeInfo().getEdge());
            ((HeapPartitionManager)object2).processSelect(selectInfo, this.getEqualityProvidingIntermediateState((IcfgEdge)term, iEqualityAnalysisResultProvider));
        }
        ((HeapPartitionManager)object2).finish();
        PartitionProjectionTransitionTransformer partitionProjectionTransitionTransformer = new PartitionProjectionTransitionTransformer(this.mLogger, ((HeapPartitionManager)object2).getSelectInfoToDimensionToLocationBlock(), computeStoreInfosAndArrayGroups, this.mHeapArrays, this.mStatistics, iIcfg.getCfgSmtToolkit());
        object3 = new IcfgTransformer<INLOC, OUTLOC>(this.mLogger, iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, "memPartitionedIcfg", partitionProjectionTransitionTransformer);
        this.mResultIcfg = ((IcfgTransformer)object3).getResult();
    }

    public void assertLiteralDisequalitiesIntoScript(Set<Term> set) {
        this.mMgdScript.lock((Object)this);
        Term term = SmtUtils.and((Script)this.mMgdScript.getScript(), (Collection)CongruenceClosureSmtUtils.createDisequalityTermsForNonTheoryLiterals((Script)this.mMgdScript.getScript(), set));
        this.mMgdScript.assertTerm((Object)this, term);
        this.mMgdScript.unlock((Object)this);
    }

    private IEqualityProvidingIntermediateState getEqualityProvidingIntermediateState(IcfgEdge icfgEdge, IEqualityAnalysisResultProvider<IcfgLocation, IIcfg<?>> iEqualityAnalysisResultProvider) {
        return iEqualityAnalysisResultProvider.getEqualityProvidingIntermediateState(icfgEdge);
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResultIcfg;
    }

    public HeapSeparatorBenchmark getStatistics() {
        return this.mStatistics;
    }

    private static ILocationFactory<BoogieIcfgLocation, BoogieIcfgLocation> createIcfgLocationToIcfgLocationFactory() {
        return (boogieIcfgLocation, debugIdentifier, string) -> {
            BoogieIcfgLocation boogieIcfgLocation2 = new BoogieIcfgLocation(debugIdentifier, string, boogieIcfgLocation.isErrorLocation(), boogieIcfgLocation.getBoogieASTNode());
            ModelUtils.copyAnnotations((IElement)boogieIcfgLocation, (IElement)boogieIcfgLocation2);
            return boogieIcfgLocation2;
        };
    }

    private static /* synthetic */ void lambda$2(FindSelects findSelects, IcfgEdge icfgEdge) {
        findSelects.processEdge(icfgEdge);
    }
}

