/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.IntVasrsAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.QvasrsSummarizer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Loop;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.LoopDetector;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.StringDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class QvasrsIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private final IIcfg<OUTLOC> mResult;
    private final IcfgTransformationBacktranslator mBackTranslationTracker;

    public QvasrsIcfgTransformer(ILogger iLogger, IIcfg<INLOC> iIcfg, Class<OUTLOC> clazz, ILocationFactory<INLOC, OUTLOC> iLocationFactory, String string, ITransformulaTransformer iTransformulaTransformer, IcfgTransformationBacktranslator icfgTransformationBacktranslator, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mScript = iIcfg.getCfgSmtToolkit().getManagedScript();
        this.mBackTranslationTracker = icfgTransformationBacktranslator;
        this.mResult = this.transform(iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, string, iTransformulaTransformer);
    }

    private IIcfg<OUTLOC> transform(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, Class<OUTLOC> clazz, String string, ITransformulaTransformer iTransformulaTransformer) {
        iTransformulaTransformer.preprocessIcfg(iIcfg);
        BasicIcfg basicIcfg = new BasicIcfg(string, iIcfg.getCfgSmtToolkit(), clazz);
        TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder = new TransformedIcfgBuilder<INLOC, OUTLOC>(this.mLogger, iLocationFactory, icfgTransformationBacktranslator, iTransformulaTransformer, iIcfg, basicIcfg);
        this.processLocations(iIcfg, iIcfg.getInitialNodes(), transformedIcfgBuilder, iLocationFactory);
        transformedIcfgBuilder.finish();
        return basicIcfg;
    }

    /*
     * WARNING - void declaration
     */
    private void processLocations(IIcfg<INLOC> iIcfg, Set<INLOC> set, TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder, ILocationFactory<INLOC, OUTLOC> iLocationFactory) {
        IcfgLocation icfgLocation;
        ArrayList<Triple> arrayList;
        Set set2 = iIcfg.getLoopLocations();
        HashMap<IcfgLocation, IntVasrsAbstraction> hashMap = new HashMap<IcfgLocation, IntVasrsAbstraction>();
        LoopDetector<INLOC> loopDetector = new LoopDetector<INLOC>(this.mLogger, iIcfg, iIcfg.getLoopLocations(), this.mScript, this.mServices, 0);
        Map<IcfgLocation, Loop> map = loopDetector.getLoopBodies();
        HashMap<IcfgLocation, UnmodifiableTransFormula> hashMap2 = new HashMap<IcfgLocation, UnmodifiableTransFormula>();
        for (Map.Entry<IcfgLocation, Loop> entry : map.entrySet()) {
            arrayList = entry.getValue().getBackbones();
            icfgLocation = new UnmodifiableTransFormula[arrayList.size()];
            int n = 0;
            for (Backbone backbone : arrayList) {
                icfgLocation[n] = (UnmodifiableTransFormula)backbone.getFormula();
                ++n;
            }
            UnmodifiableTransFormula unmodifiableTransFormula = TransFormulaUtils.parallelComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, null, (boolean)false, (boolean)false, (UnmodifiableTransFormula[])icfgLocation);
            this.mLogger.warn((Object)unmodifiableTransFormula.toStringDirect());
            hashMap2.put(entry.getKey(), unmodifiableTransFormula);
        }
        QvasrsSummarizer qvasrsSummarizer = new QvasrsSummarizer(this.mLogger, this.mServices, this.mScript);
        for (Map.Entry entry : hashMap2.entrySet()) {
            hashMap.put((IcfgLocation)entry.getKey(), QvasrUtils.qvasrsAbstactionToIntVasrsAbstraction(this.mScript, qvasrsSummarizer.computeQvasrsAbstraction((UnmodifiableTransFormula)entry.getValue(), true)));
        }
        IcfgLocationIterator icfgLocationIterator = new IcfgLocationIterator(set);
        arrayList = new ArrayList<Triple>();
        while (icfgLocationIterator.hasNext()) {
            Object object;
            icfgLocation = icfgLocationIterator.next();
            if (set2.contains(icfgLocation)) {
                Integer n;
                UnmodifiableTransFormula unmodifiableTransFormula;
                IcfgLocation icfgLocation2;
                Term[][] termArray;
                Term[][] termArray2;
                boolean bl = false;
                IntVasrsAbstraction intVasrsAbstraction = (IntVasrsAbstraction)hashMap.get(icfgLocation);
                object = new HashMap();
                for (Term term : intVasrsAbstraction.getStates()) {
                    void var15_26;
                    termArray2 = new StringDebugIdentifier("QVASRSnode " + Integer.toString((int)var15_26));
                    termArray = new IcfgLocation((DebugIdentifier)termArray2, icfgLocation.getProcedure());
                    object.put(term, termArray);
                    ++var15_26;
                }
                Term[] termArray3 = intVasrsAbstraction.getInVars().values().toArray(new Term[intVasrsAbstraction.getInVars().size()]);
                Term[] termArray4 = intVasrsAbstraction.getOutVars().values().toArray(new Term[intVasrsAbstraction.getOutVars().size()]);
                termArray2 = QvasrUtils.matrixVectorMultiplicationWithVariables(this.mScript, intVasrsAbstraction.getSimulationMatrix(), QvasrUtils.transposeRowToColumnTermVector(termArray3));
                termArray = QvasrUtils.matrixVectorMultiplicationWithVariables(this.mScript, intVasrsAbstraction.getSimulationMatrix(), QvasrUtils.transposeRowToColumnTermVector(termArray4));
                for (Triple<Term, Pair<Integer[], Integer[]>, Term> triple2 : intVasrsAbstraction.getTransitions()) {
                    icfgLocation2 = (IcfgLocation)object.get(triple2.getFirst());
                    IcfgLocation icfgLocation3 = (IcfgLocation)object.get(triple2.getThird());
                    int n2 = 0;
                    while (n2 < ((Integer[])((Pair)triple2.getSecond()).getFirst()).length) {
                        TermVariable termVariable;
                        Object object2;
                        Term term;
                        unmodifiableTransFormula = new HashSet();
                        n = ((Integer[])((Pair)triple2.getSecond()).getFirst())[n2];
                        Integer n3 = ((Integer[])((Pair)triple2.getSecond()).getSecond())[n2];
                        if (n == 0) {
                            term = SmtUtils.binaryEquality((Script)this.mScript.getScript(), (Term)termArray[n2][0], (Term)this.mScript.getScript().numeral(n3.toString()));
                            unmodifiableTransFormula.add(term);
                        } else {
                            term = SmtUtils.sum((Script)this.mScript.getScript(), (String)"+", (Term[])new Term[]{termArray2[n2][0], this.mScript.getScript().decimal(n3.toString())});
                            object2 = SmtUtils.binaryEquality((Script)this.mScript.getScript(), (Term)termArray[n2][0], (Term)term);
                            unmodifiableTransFormula.add(object2);
                        }
                        term = SmtUtils.and((Script)this.mScript.getScript(), (Collection)unmodifiableTransFormula);
                        term = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{term, (Term)triple2.getThird()});
                        object2 = new HashMap();
                        HashMap<IProgramVar, TermVariable> hashMap3 = new HashMap<IProgramVar, TermVariable>();
                        HashMap<Term, TermVariable> hashMap4 = new HashMap<Term, TermVariable>();
                        for (Map.Entry<IProgramVar, TermVariable> entry : intVasrsAbstraction.getInVars().entrySet()) {
                            termVariable = this.mScript.constructFreshCopy(entry.getValue());
                            object2.put(entry.getKey(), termVariable);
                            hashMap4.put((Term)entry.getValue(), termVariable);
                        }
                        for (Map.Entry<IProgramVar, TermVariable> entry : intVasrsAbstraction.getOutVars().entrySet()) {
                            termVariable = this.mScript.constructFreshCopy(entry.getValue());
                            hashMap3.put(entry.getKey(), termVariable);
                            hashMap4.put((Term)entry.getValue(), termVariable);
                        }
                        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder((Map)object2, hashMap3, true, null, true, null, true);
                        transFormulaBuilder.setFormula(Substitution.apply((ManagedScript)this.mScript, hashMap4, (Term)term));
                        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
                        UnmodifiableTransFormula unmodifiableTransFormula2 = transFormulaBuilder.finishConstruction(this.mScript);
                        transformedIcfgBuilder.createNewInternalTransition((Iterator<Triple<Term, Pair<Integer[], Integer[]>, Term>>)icfgLocation2, (Iterator<Triple<Term, Pair<Integer[], Integer[]>, Term>>)icfgLocation3, unmodifiableTransFormula2, false);
                        ++n2;
                    }
                }
                Iterator<Triple<Term, Pair<Integer[], Integer[]>, Term>> iterator = transformedIcfgBuilder.createNewLocation(icfgLocation);
                IcfgLocation icfgLocation4 = map.get(icfgLocation).getLoopExit();
                Iterator<Triple<Term, Pair<Integer[], Integer[]>, Term>> iterator2 = transformedIcfgBuilder.createNewLocation(icfgLocation4);
                icfgLocation2 = QvasrUtils.buildFormula(this.mScript, intVasrsAbstraction.getPostState(), intVasrsAbstraction.getOutVars(), intVasrsAbstraction.getOutVars());
                transformedIcfgBuilder.createNewInternalTransition(iterator, iterator2, (UnmodifiableTransFormula)icfgLocation2, false);
                for (Term term : intVasrsAbstraction.getStates()) {
                    unmodifiableTransFormula = QvasrUtils.buildFormula(this.mScript, intVasrsAbstraction.getPreState(), intVasrsAbstraction.getInVars(), intVasrsAbstraction.getInVars());
                    n = (IcfgLocation)object.get(term);
                    transformedIcfgBuilder.createNewInternalTransition(iterator, (Iterator<Triple<Term, Pair<Integer[], Integer[]>, Term>>)((Object)n), unmodifiableTransFormula, false);
                }
                for (Term term : intVasrsAbstraction.getStates()) {
                    unmodifiableTransFormula = QvasrUtils.buildFormula(this.mScript, intVasrsAbstraction.getPostState(), intVasrsAbstraction.getOutVars(), intVasrsAbstraction.getOutVars());
                    n = (IcfgLocation)object.get(term);
                    transformedIcfgBuilder.createNewInternalTransition((Iterator<Triple<Term, Pair<Integer[], Integer[]>, Term>>)((Object)n), iterator2, unmodifiableTransFormula, false);
                }
                continue;
            }
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                Iterator<Triple<Term, Pair<Integer[], Integer[]>, Term>> iterator = transformedIcfgBuilder.createNewLocation(icfgLocation);
                object = transformedIcfgBuilder.createNewLocation((IcfgLocation)icfgEdge.getTarget());
                if (icfgEdge instanceof IIcfgReturnTransition) {
                    arrayList.add(new Triple(iterator, object, (Object)icfgEdge));
                    continue;
                }
                transformedIcfgBuilder.createNewTransition(iterator, (Iterator<Triple<Term, Pair<Integer[], Integer[]>, Term>>)object, icfgEdge);
            }
        }
        arrayList.forEach(triple -> {
            IcfgEdge icfgEdge = transformedIcfgBuilder.createNewTransition((Iterator<Triple<Term, Pair<Integer[], Integer[]>, Term>>)((IcfgLocation)triple.getFirst()), (Iterator<Triple<Term, Pair<Integer[], Integer[]>, Term>>)((IcfgLocation)triple.getSecond()), (IcfgEdge)triple.getThird());
        });
    }

    private UnmodifiableTransFormula edgesToFormula(Deque<IcfgEdge> deque) {
        ArrayList<UnmodifiableTransFormula> arrayList = new ArrayList<UnmodifiableTransFormula>();
        for (IcfgEdge icfgEdge : deque) {
            arrayList.add(icfgEdge.getTransformula());
        }
        return TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (boolean)true, (boolean)true, (boolean)false, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.POLY_PAC, arrayList);
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResult;
    }
}

